/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.utility.TextAboveCreatureAction;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class DancePower
extends AbstractPower {
    public static final String POWER_ID = "Dance Puppet";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Dance Puppet");
    public static final String NAME = DancePower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = DancePower.powerStrings.DESCRIPTIONS;
    private AbstractCard.CardType typeToCompare = AbstractCard.CardType.SKILL;
    private boolean firstTurnApplied = true;

    public DancePower(AbstractCreature owner, int amount) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amount;
        this.updateDescription();
        this.type = AbstractPower.PowerType.DEBUFF;
    }

    @Override
    public void updateDescription() {
        if (this.typeToCompare == AbstractCard.CardType.SKILL) {
            this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1];
            this.img = ImageMaster.loadImage("images/powers/32/puppetSkill.png");
        } else {
            this.img = ImageMaster.loadImage("images/powers/32/puppetAttack2.png");
            this.description = DESCRIPTIONS[2] + this.amount + DESCRIPTIONS[1];
        }
    }

    @Override
    public void onUseCard(AbstractCard card, UseCardAction action) {
        if (card.type != this.typeToCompare) {
            this.flash();
            AbstractDungeon.actionManager.addToBottom(new DamageAction(this.owner, new DamageInfo(this.owner, this.amount, DamageInfo.DamageType.THORNS), AbstractGameAction.AttackEffect.FIRE));
            ++this.amount;
            AbstractDungeon.actionManager.addToBottom(new TextAboveCreatureAction(this.owner, DESCRIPTIONS[3]));
            this.updateDescription();
        }
    }

    @Override
    public void atStartOfTurn() {
        if (this.firstTurnApplied) {
            this.firstTurnApplied = false;
        } else {
            this.flash();
            if (this.typeToCompare == AbstractCard.CardType.SKILL) {
                this.typeToCompare = AbstractCard.CardType.ATTACK;
                this.updateDescription();
            } else {
                this.typeToCompare = AbstractCard.CardType.SKILL;
                this.updateDescription();
            }
        }
    }
}

